fuses = {};
	
function startup()
{
	partName = '';
	var qs = window.location.search;
	if (qs.match(/\?part=(.+)$/)) {
		partName = RegExp.$1;
	}

	fill_parts();
	translate_static();
	if (partName.length > 0) {
		load_part_description();
	}
}


function load_part_description()
{
	var script = document.createElement('script');
	script.setAttribute('src', 'js/' + partName + '.js');
	document.getElementsByTagName('head')[0].appendChild(script);
}

function fill_parts()
{
	var part = document.getElementById('part');
	part.innerHTML = '';
	var option = document.createElement('option');
	option.value = '';
	option.appendChild(document.createTextNode('------'));
	part.appendChild(option);
	for (var i in parts) {
		var option = document.createElement('option');
		option.value = parts[i];
		option.appendChild(document.createTextNode(parts[i]));
		if (parts[i] == partName) {
			option.selected = true;
		}
		part.appendChild(option);
	}
}

function translate_static()
{
	var elements = document.getElementsByName('translate[]');
	for (var i=0; i < elements.length; i++) {
		var el = elements[i];
		el.innerHTML = translate(el.getAttribute('translate'));
	}
}

function translate(str)
{
	if (ru[str]) return ru[str];
	return str;
}

function create_interface()
{
	for (var fuse_name in fuse_defs) {
		fuses[fuse_name] = 0xFF;
		byte_def = fuse_defs[fuse_name];
		for (var i in byte_def.bits) {
			if (byte_def.bits[i].default_value == 0) {
				fuses[fuse_name] &= ~(1 << i);
			}
		}

		create_bits(fuse_name);

		for (var mask_name in byte_def.options) {
			var options = byte_def.options[mask_name];
			if (options.length > 1) {
				create_select(fuse_name, options);
			} else {
				create_checkbox(fuse_name, options[0]);
			}
		}
		create_byte_input(fuse_name);
	}
	var bits_div = document.getElementById('bits');
	var div = document.createElement('div');
	div.className = 'clear';
	bits_div.appendChild(div);

	update_interface();

	document.getElementById('hide1').style.display = '';
	document.getElementById('hide2').style.display = '';
}

function create_bit(fuse_name, i) {
	var div = document.createElement('div');
	div.className = 'bit_content';


	if (fuse_defs[fuse_name].bits[i]) {
		var bit_name = fuse_defs[fuse_name].bits[i].name;
		var bit_text = translate(fuse_defs[fuse_name].bits[i].text);
		var name = fuse_name + '_bit_' + i;
		var cb = document.createElement('input');
		cb.setAttribute('type', 'checkbox');
		cb.setAttribute('name', name);
		cb.setAttribute('id', name);

		cb.onclick = function() {
			set_fuse_value(fuse_name, 1 << i, this.checked ? 0 : 1<<i);
		}
		div.appendChild(cb);

		var span = document.createElement('span');
		span.className = 'bit_name_label';
		var label = document.createElement('label');
		span.appendChild(label);
		label.appendChild(document.createTextNode(bit_name));
		label.setAttribute('for', name);
		div.appendChild(span);

		div.appendChild(document.createElement('br'));

		var span = document.createElement('span');
		span.className = 'bit_name_descr';
		span.setAttribute('name', 'translate[]');
		span.setAttribute('translate', bit_text);
		span.appendChild(document.createTextNode(translate(bit_text)));
		div.appendChild(span);
	}
	return div;
}

function create_bits(fuse_name) {
		var bits_div = document.getElementById('bits');
		var names_div = document.createElement('div');
		names_div.className = 'bit_names';
		bits_div.appendChild(names_div);

		var name_div = document.createElement('div');
		name_div.appendChild(document.createTextNode(fuse_name));
		name_div.className = 'bit_name';
		names_div.appendChild(name_div);

		for (var i = 7; i >= 0; i--) {
			var div = create_bit(fuse_name, i);
			names_div.appendChild(div);
		}


}

function create_select(fuse_name, defs)
{
	var features_div = document.getElementById('features');
	var div = document.createElement('div');
	features_div.appendChild(div);

	var select = document.createElement('select');
	var name = fuse_name + '_' + defs[0].mask;
	select.setAttribute('name', name);
	select.setAttribute('id', name);

	select.onchange = function() {
		set_fuse_value(fuse_name, defs[0].mask, this.value);
	}
	for (var i = 0; i < defs.length; i++) {
		var def = defs[i];
		var option = document.createElement('option');
		option.value = def.value;
		option.appendChild(document.createTextNode(translate(def.text)));
		select.appendChild(option);
	}
	div.appendChild(select);
}

function create_checkbox(fuse_name, def)
{
	var features_div = document.getElementById('features');
	var div = document.createElement('div');
	features_div.appendChild(div);

	var cb = document.createElement('input');
	var name = fuse_name + '_' + def.mask;
	cb.setAttribute('type', 'checkbox');
	cb.setAttribute('name', name);
	cb.setAttribute('id', name);

	cb.onclick = function() {
		set_fuse_value(fuse_name, def.mask, this.checked ? 0x00 : 0xFF);
	}

	div.appendChild(cb);

	var label = document.createElement('label');
	label.setAttribute('for', name);
	label.appendChild(document.createTextNode(translate(def.text)));
	div.appendChild(label);

}

function create_byte_input(fuse_name)
{
	var bytes_div = document.getElementById('bytes');
	
	var span = document.createElement('span');
	span.appendChild(document.createTextNode('0x'));
	bytes_div.appendChild(span);

	var name = fuse_name + '_byte';
	var input = document.createElement('input');
	input.setAttribute('size', 3);
	input.setAttribute('maxlength', 2);
	input.setAttribute('name', name);
	input.setAttribute('id', name);
	bytes_div.appendChild(input);

	input.onfocus = function() {
		this.setAttribute('correct_value', this.value);
	}

	input.onchange = function() {
		if (!this.value.match(/^[0-9A-Fa-f][0-9a-fA-F]/)) {
			this.value = this.getAttribute('correct_value');
		}
		set_fuse_value(fuse_name, 0xFF,  eval('0x' + this.value));
	}

	var span = document.createElement('span');
	span.appendChild(document.createTextNode('\u00a0\u00a0' + fuse_name));
	bytes_div.appendChild(span);

	bytes_div.appendChild(document.createElement('br'));

}

function set_fuse_value(name, mask, value)
{
	fuses[name] &= ~mask;
	fuses[name] |= (value & mask);
	update_interface();
}

function update_interface()
{
	for (var fuse_name in fuse_defs) {
		byte_def = fuse_defs[fuse_name];
		for (var mask_name in byte_def.options) {
			var options = byte_def.options[mask_name];
			var name = fuse_name + '_' + options[0].mask;
			if (options.length > 1) {
				document.getElementById(name).value = fuses[fuse_name] & options[0].mask;
			} else {
				document.getElementById(name).checked = !(fuses[fuse_name] & options[0].mask);
			}
		}
		for (var i=0; i < 8; i++) {
			var name = fuse_name + '_bit_'  + i;
			var el = document.getElementById(name);
			if (el) {
				el.checked = (fuses[fuse_name] & (1 << i)) == 0;
			}
		}
		document.getElementById(fuse_name + '_byte').value = tohex(fuses[fuse_name]);
	}
}

function tohex(num)
{
	var ret = num.toString(16);
	if (ret.length < 2) {
		ret = '0' + ret;
	}
	return ret.toUpperCase();
}



